//
//  MCFileIOChannel.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 22/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCNetComm/MCIOChannel.h>

#import <Security/Security.h>


#define MC_CHANNEL_DEBUG 0

#define SCALED_WAIT_INTERVAL 1

@interface MCFileIOChannel : MCIOChannel {

	NSString *inputFilePath;
	NSString *outputFilePath;
	
	NSFileHandle *inputFH;
	NSFileHandle *outputFH;
#if MC_CHANNEL_DEBUG
	NSFileHandle *inputLogFH;
#endif
	
	NSMutableArray *readQueue;
	id currentRead;
	NSTimer *readTimer; // timeout
	
	NSData *inputBuffer;
	
	BOOL closeAfterWriting;
	BOOL checkForPing;

@private
	NSMutableArray *encryptedPackets;
	unsigned long encryptedDataLength;
	size_t currentPacketIndex;

	SSLContextRef sslContext;
	BOOL sslHandshakeDone;
	BOOL secureReadInProgress;
#if SCALED_WAIT_INTERVAL
	NSTimeInterval runLoopWaitInterval;
#endif
}

- (NSString *)inputFilePath;
- (void)setInputFilePath:(NSString *)anInputFilePath;
- (NSString *)outputFilePath;
- (void)setOutputFilePath:(NSString *)anOutputFilePath;

- (SSLContextRef)sslContext;

- (BOOL)hasEncryptedData;

- (id)initWithInputFile:(NSString *)inputPath outputFile:(NSString *)outputPath delegate:(id)object;

- (BOOL)checkForPing;
- (void)setCheckForPing:(BOOL)flag;

@end
